% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/power_Binomial.R
\name{power_Binomial}
\alias{power_Binomial}
\title{Power Calculations for Two-Sample Test for Proportions}
\usage{
power_Binomial(n1 = NULL, n2 = NULL, p1 = 0.5, p2 = 0.5, 
sig.level = 0.05, power = NULL, equal.sample = TRUE,
alternative = c("two.sided", "one.sided"))
}
\arguments{
\item{n1}{sample size in group 1, or sample size in each group if equal.sample = TRUE}

\item{n2}{sample size in group 2}

\item{p1}{probability in group 1}

\item{p2}{probability in group 2}

\item{sig.level}{significance level (Type I error probability)}

\item{power}{power of test (1 minus Type II error probability)}

\item{equal.sample}{equal sample sizes for two groups, see details}

\item{alternative}{one- or two-sided test}
}
\value{
Object of class "power.htest", a list of the arguments (including the computed one) augmented with note and method elements.
}
\description{
Compute power of test, or determine parameters to obtain target power for equal and unequal sample sizes.
}
\details{
Exactly one of the parameters \code{n1}, \code{n2}, \code{p1}, \code{p2}, \code{power}, and \code{sig.level} must be passed as NULL, and that parameter is determined from the others.
Notice that \code{p1}, \code{p2}, \code{sig.level} have non-NULL defaults, so NULL must be explicitly expressed if you want to compute them.\cr\cr
If \code{equal.sample = TRUE} is used, N in output will denote the number in each group.\cr\cr
}
\examples{
# calculate power, equal sizes
power_Binomial(n1 = 100, p1 = 0.5, p2 = 0.7)
# calculate power, unequal sizes
power_Binomial(n1 = 150, n2 = 100, p1 = 0.5, p2 = 0.7)
# calculate n2
power_Binomial(n1 = 100, p1 = 0.5, p2 = 0.7, power = 0.9, equal.sample = FALSE)
}
