% Generated by roxygen2 (4.0.2): do not edit by hand
\name{GOpredict}
\alias{GOpredict}
\title{Predict GO annotations for proteins}
\usage{
GOpredict(Pfile, PPIdb, Gene2Annotation, p_value=0.001)
}
\arguments{
\item{Pfile}{A data frame returned from the function "SignificantPairs"}

\item{PPIdb}{A 2-column data frame consisting of binary interactions where each row i.e. c(A, B) represents an undirected edge (interaction) between gene A and gene B.}

\item{Gene2Annotation}{A list that maps GO ID to genes. The names should be gene symbols and the elements should be GO IDs. i.e.

    $SHC1

    [1] "GO:0005158" "GO:0005068" "GO:0005159" "GO:0070435"

    $POU5F1

    [1] "GO:0035413" "GO:0003130" "GO:0060391" "GO:0090308" "GO:0060965" "GO:0035198"

    $FGF12

    [1] "GO:0008201"

    ......}

\item{p_value}{A cut-off for p-values from Fishers exact test when predicting GO annotations}
}
\value{
This function returns a data frame with column names: "Symbol", "GOID", "GOterm", "Ratio" and "Pvalue". "Symbol" is the name of the node this function predicts GO annotation for. "GOID" and "GOterm" are the predicted GO ID and the GO term, respectively. "Ratio" is the proportion of neighboring nodes that have the predicted GO annotation. "Pvalue" is calculated from the "Ratio" by Fishers exact test.
}
\description{
This function uses a direct annotation scheme to predict GO annotations for proteins in the network derived with the PAND algorithm
}
\seealso{
\code{\link{SignificantPairs}}, \code{\link{ProteinCluster}}, \code{\link{KEGGpredict}}, \code{\link{SignificantSubcluster}}
}

