% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/visualisation.R
\name{draw_heatmap}
\alias{draw_heatmap}
\title{Draw network of enriched functional annotation pairs as a heatmap}
\usage{
draw_heatmap(graph, adjMethod = NULL, xlab = "downstream",
  ylab = "upstream", colPal = NULL)
}
\arguments{
\item{graph}{The output of either the pafway or pafway_edge_weight functions}

\item{adjMethod}{The method for correcting for multiple hypotheses.  This can be any method that is acceptable to the p.adjust function in the stats package: "holm", "hochberg", "hommel", "bonferroni", "BH", "BY", "fdr" or "none".  If this is NULL, then no adjustment will be made.}

\item{xlab}{The label for the x-axis of the heatmap}

\item{ylab}{The label for the y-axis of the heatmap}

\item{colPal}{The color palette of the heatmap}
}
\value{
A matrix that has the same number of rows and columns as length(GOtypes).  This will contain p-values.
}
\description{
Draw network of enriched functional annotation pairs as a heatmap
}
\examples{
nodes=paste("node", c(1:300))
set.seed(123)
randomGO=c("A", "B", "C", "D", "E", "F", "G", "H", "I",
"J", "K", "L", "M", "N")[sample(c(1:14), 300, replace=TRUE)]
names(randomGO)=nodes
edgesRandom=sapply(c(1:1000), function(i){
   nodes[sample(300, 2)]
})
getBinomPvalueRandom1=pafway(randomGO, t(edgesRandom), unique(randomGO))
draw_heatmap(getBinomPvalueRandom1)
colPal1=c(colorRampPalette(c("red3", "lightpink", "white", "white"))(20),
colorRampPalette(c("white", "white", "lightgreen", "darkgreen"))(20))
draw_heatmap(getBinomPvalueRandom1, adjMethod="bonferroni", xlab="Downstream",
ylab="Upstream", colPal=colPal1)
}
