\name{p2c2m.complete}
\alias{p2c2m.complete}
\title{Execute the complete P2C2M pipeline via a single command}

\description{
  This function executes the complete \pkg{P2C2M} pipeline from beginning to end.
}

\usage{
p2c2m.complete(path = "/home/user/Desktop/", xml.file = "beast.xml", 
    descr.stats = "GTP,NDC", beast.vers = "1.8", single.allele = c("O"), 
    num.reps = 100, use.sorted = FALSE, use.mpi = FALSE, verbose = FALSE,
    dbg = FALSE)
}

\arguments{
  \item{path}{an absolute file path to an input folder, specified as a 
    double-quoted string; if \code{"/home/user/Desktop/"} (the default), then 
    the desktop itself is considered the input folder.}

  \item{xml.file}{the name of the file in .xml-format that was generated by 
    BEAUTi in order to perform a species tree inference in *BEAST, specified 
    as a double-quoted string; if \code{"beast.xml"} (the default), then the 
    BEAUTi file in .xml-format is expected to be named \code{"beast.xml"}.}

  \item{descr.stats}{the name(s) of the descriptive statistic(s) the user 
    wishes to utilize, specified as a double-quoted string, whereby the 
    individual statistics are separated by commas. Four descriptive statistics
    are currently available: \code{"GSI"}, \code{"GTP"}, \code{"NDC"}, and 
    \code{"RAY"}. The default is \code{"GTP,NDC"}.}

  \item{beast.vers}{the version of BEAST/*BEAST used to perform the species 
    tree inference, specified as a double-quoted string. Appropriate parsers 
    must me located in the R subdirectory exec/ to be recognized. Currently, 
    the possible choices are: \code{"1.7"} and \code{"1.8"}. By default, the 
    version of BEAST/*BEAST is set to \code{"1.8"}.}

  \item{single.allele}{the name of those species that are represented by only 
    a single allele, specified as a variable of mode vector. Species so 
    defined do not contribute towards the calculation of descriptive 
    statistic 'GSI'. By default, the name is set to \code{c("O")}.}

  \item{num.reps}{the number of simulation replicates to be conducted, 
    specified as an integer. By default, the number of simulation replicates 
    is set to \code{100}.}

  \item{use.sorted}{a logical specifying if the descriptive statistics 
    from the posterior distribution and the posterior predictive distributions 
    are ranked by magnitude prior to the calculation of differences. By 
    default, this parameter is set to \code{FALSE}.}

  \item{use.mpi}{a logical specifying if \pkg{P2C2M} takes advantage of 
    multiple CPUs present on the system (if such exist) in order to speed up 
    the calculation of descriptive statistic. By default, this parameter is 
    set to \code{FALSE}.}

  \item{verbose}{a logical specifying if \pkg{P2C2M} prints status information 
    to the screen. Default is \code{FALSE}.}

  \item{dbg}{a logical specifying if \pkg{P2C2M} is to be run in its debug 
    mode. If \code{TRUE}, then (a) only the first 5 percent of input trees are 
    analyzed, (b) intermittent results are saved to file, and (c) information 
    useful for debugging is printed to the screen during the code execution. 
    Argument \code{dbg = TRUE} must be set in combination with argument 
    \code{verbose = TRUE}. Default is \code{FALSE}.}
}

\details{
  The default setting of parameter \code{single.allele} expects that the data 
  set contains an outgroup that consists of only a single allele. 
}

\value{
  Description of the output here.
}

\author{
  Michael Gruenstaeudl, Noah Reid

  Maintainer: Michael Gruenstaeudl \email{gruenstaeudl.1@osu.edu}
}

\references{
  Cummings, M.P., Neel, M.C. and Shaw, K.L. (2008) A genealogical approach to 
  quantifying lineage divergence. \emph{Evolution}, \bold{62}, 2411-2422.
}

\examples{
## Example of the minimal data requirements to run P2C2M

# The absolute path to the input folder is set
inPath <- system.file("extdata", "sim.E.003.small/", package="P2C2M")

# The name of the xml-file generated by BEAUTi and located in 
# "inPath" is set
inFile <- "sim.E.003.small.xml"

# Posterior predictive simulations with a setting of 2 simulation 
# replicates are preformed
sim.E.003.small <- p2c2m.complete(inPath, inFile, num.reps=2)
}

