#!/usr/bin/env python2
# '''Parsing XML files that were generated by BEAUTi v.1.8'''
# __author__ = "Michael Gruenstaeudl, PhD"
# __copyright__ = "Copyright (C) 2014 Michael Gruenstaeudl"
# __email__ = "gruenstaeudl.1@osu.edu"
# __version__ = "2014.10.04.0100"
# __status__ = "Working"

# I/P:
# InFn = filename of the xml input file
#
# O/P:
# SAmtrx = species allele matrix
# LPmtrx = locus ploidy matrix
# GPmtrx = gene partition matrix
# ALNdict = alignment dictionary

#####################
# IMPORT OPERATIONS #
#####################

# Is importing sys really necessary?
#import sys
import xml.etree.ElementTree as etree
from itertools import izip

############
# RAW CODE #
############

# TFL corrects the filename to be in ascii format
# inFn = inFn.encode('ascii')

# "inFn" is the filename of the xml input file
# etree.parse() parses a file from the harddisk
rootElem = etree.parse(inFn).getroot()

#######################################
## 1. Extract xml sections by keyword #
#######################################
## Extract the xml sections "alignment", "species", "taxa", and
## "treeLikelihood" from rootElem
#allDict = {}
#for keyw in ["alignment", "species", "taxa", "treeLikelihood"]:
#    tmpList = []
#    for entry in rootElem.findall(keyw):
#        tmpList.append(entry)
#    allDict[keyw] = tmpList
## "allDict" now contains several xml-sections
## > allDict
## {'alignment': [<Element 'alignment' at 0x7f8384ea7f90>,
##  <Element 'alignment' at 0x7f8384e94c90>,
##  'species': [<Element 'species' at 0x7f83849e4510>],
##  'taxa': [<Element 'taxa' at 0x7f8384ea72d0>, ...]}

#########################################
# 2. Extract species-allele association #
#########################################
# Extract the association of "species" to "alleles" and save to SAmtrx
SAmtrx = []
sp = [sp for sp in rootElem.iter("sp") if sp.attrib.keys()[0]=="id"]
for s in sp:
    taxa = [taxon for taxon in s.iter("taxon")]
    for t in taxa:
        SAmtrx.append([s.get("id"), t.get("idref")])

# LEGACY:
# for species in allDict["species"][0].findall("sp"):
#     for allele in species:
#         SAmtrx.append([species.attrib["id"], allele.attrib["idref"]])

#######################################
# 3. Extract locus-ploidy association #
#######################################
# Extract the association of "gene names" to "ploidy" and save to LPmtrx
LPmtrx = []
for entry in rootElem.iter("gtree"):
    ploidy = entry.get("ploidy")
    gene = [gene.get("idref") for gene in entry.iter("treeModel")]
    # Note: .rstrip("treeModel").rstrip(".") preferential over
    #       .rstrip(".treeModel"), because R interprets the latter as 
    #       "any treeModel"
    gene = gene[0].rstrip("treeModel").rstrip(".")
    LPmtrx.append([gene, ploidy])

# LEGACY:
#for ploidy in allDict["species"][0][-1].findall("gtree"):
#    gene = ploidy.findall("treeModel")[0].attrib["idref"]
#    LPmtrx.append([gene.rstrip("treeModel").rstrip("."),
#                   ploidy.attrib["ploidy"]])

##################################
# 4. Extract gene-partition info #
##################################
# Extract gene-partition info from allDict and save to GPmtrx
GPmtrx = []
tL = [tL for tL in rootElem.iter("treeLikelihood") if tL.attrib.keys()[0]=="id"]
for l in tL:
    gene = [gene.get("idref") for gene in l.iter("treeModel")]
    # Note: .rstrip("treeModel").rstrip(".") preferential over
    #       .rstrip(".treeModel"), because R interprets the latter as
    #       "any treeModel"
    gene = gene[0].rstrip("treeModel").rstrip(".")
    part = [part.get("idref") for part in l.iter("patterns")]
    part = part[0].rstrip("patterns").rstrip(".")
    GPmtrx.append([gene, part])

# LEGACY
#for entry in allDict["treeLikelihood"]:
#    gene = entry.findall("treeModel")[0].attrib["idref"]
#    gene = gene.rstrip("treeModel").rstrip(".")
#    partition = entry.findall("patterns")[0].attrib["idref"]
#    partition = partition.rstrip("patterns").rstrip(".")
#    GPmtrx.append([gene, partition])

#########################
# 5. Extract alignments #
#########################
# Extract alignments and save to ALNdict
# Note:  simple (or nested) Python-lists are being converted to simple
#        (or nested) unnamed R-lists by the rPython-package;
# Note:  Python-dictionaries are being converted to named R-lists by the
#        rPython-package, whereby the new R-list name is the former
#        Python-dictionary key
ALNdict = {}
# Some alignment elements only have a single attrib.; they can be cleaned out by this fact
alignms = [alignm for alignm in rootElem.iter("alignment") if len(alignm.attrib.keys()) > 1]
patterns = [pat for pat in rootElem.iter("patterns") if len(pat.attrib.keys()) >= 3]
for (a, p) in izip(alignms, patterns):
    taxDict = {}
    for taxon in a.iter("taxon"):
        taxDict[taxon.get("idref")] = list(taxon.tail.replace("\n","").replace("\t",""))
    patternDict = {}
    for alignm in p.iter("alignment"):
        patternDict[alignm.get("idref")] = p.get("id").rstrip("patterns").rstrip(".")
    ALNdict[patternDict[a.get("id")]] = taxDict

#for alignm in allDict["alignment"]:
#    tmpDict = {}
#    for seq in alignm.findall("sequence"):
#        tmp = list(seq[0].tail.replace("\t", "").replace("\n", ""))
#        tmpDict[seq[0].attrib["idref"]] = tmp
#
#    geneNum = int(alignm.attrib["id"].lstrip("alignment"))-1
#
#    geneName = allDict["treeLikelihood"][geneNum]
#    geneName = geneName.findall("treeModel")[0].attrib["idref"]
#    geneName = geneName.rstrip("treeModel").rstrip(".")
#
#    ALNdict[geneName] = tmpDict
