% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/OptHoldoutSize_aspre.R
\name{aspre_k2}
\alias{aspre_k2}
\title{Cost estimating function in ASPRE simulation}
\usage{
aspre_k2(
  n,
  X,
  PRE,
  seed = NULL,
  pi_PRE = 1426/58974,
  pi_intervention = 0.1,
  alpha = 0.37
)
}
\arguments{
\item{n}{Holdout set size at which to estimate k_2 (cost)}

\item{X}{Matrix of predictors}

\item{PRE}{Vector indicating PRE incidence}

\item{seed}{Random seed; set before starting or set to NULL}

\item{pi_PRE}{Population prevalence of PRE if not prophylactically treated. Defaults to empirical value 1426/58974}

\item{pi_intervention}{Proportion of the population on which an intervention will be made. Defaults to 0.1}

\item{alpha}{Reduction in PRE risk with intervention. Defaults to empirical value 0.37}
}
\value{
Estimated cost
}
\description{
Estimate cost at a given holdout set size in ASPRE model
}
\examples{

# Simulate
set.seed(32142)

N=1000; p=15
X=matrix(rnorm(N*p),N,p); PRE=rbinom(N,1,prob=logit(X\%*\% rnorm(p)))
aspre_k2(1000,X,PRE)
}
\keyword{aspre}
