% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calc.r
\name{statsElements}
\alias{statsElements}
\alias{statsConstructs}
\title{Descriptive statistics for constructs and elements}
\usage{
statsElements(x, index = TRUE, trim = 20)

statsConstructs(x, index = T, trim = 20)
}
\arguments{
\item{x}{\code{repgrid} object.}

\item{index}{Whether to print the number of the element.}

\item{trim}{The number of characters an element or a construct is trimmed to (default is \code{20}). If \code{NA} no trimming
occurs. Trimming simply saves space when displaying correlation of constructs or elements with long names.}
}
\value{
A dataframe containing the following measures is returned invisibly (see \code{\link[psych:describe]{psych::describe()}}):
\itemize{
\item item name
\item item number
\item number of valid cases
\item mean standard deviation
\item trimmed mean (default \code{.1})
\item median (standard or interpolated)
\item mad: median absolute deviation (from the median)
\item minimum
\item maximum
\item skew
\item kurtosis
\item standard error
}
}
\description{
Several descriptive measures for constructs and elements.
}
\note{
Note that standard deviation and variance are estimations, i.e. including Bessel's correction. For more info
type \code{?describe}.
}
\examples{

statsConstructs(fbb2003)
statsConstructs(fbb2003, trim = 10)
statsConstructs(fbb2003, trim = 10, index = FALSE)

statsElements(fbb2003)
statsElements(fbb2003, trim = 10)
statsElements(fbb2003, trim = 10, index = FALSE)

# save the access the results
d <- statsElements(fbb2003)
d
d["mean"]
d[2, "mean"] # mean rating of 2nd element

d <- statsConstructs(fbb2003)
d
d["sd"]
d[1, "sd"] # sd of ratings on first construct

}
