% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/generalfunctions.R
\name{summary_map}
\alias{summary_map}
\title{Quantitative summary of a unique categorical raster}
\usage{
summary_map(path)
}
\arguments{
\item{path}{The path for the raster to be analysed, if path is a multilayer
raster only the first RasterLayer will be analysed.}
}
\value{
A table containing in columns the pixel counts for each pixel value
}
\description{
This function presents a summary with the pixel quantity of each category
present in a categorical raster.
}
\examples{
\donttest{
url <- "https://zenodo.org/record/3685230/files/SaoLourencoBasin.rda?download=1"
temp <- tempfile()
download.file(url, temp, mode = "wb") # downloading the SaoLourencoBasin dataset
load(temp)
summary_map(SaoLourencoBasin[[1]])
}

}
