% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get.qc.barplot.R
\name{get.qc.barplot}
\alias{get.qc.barplot}
\title{Generates the standard barplot of scores for each sample}
\usage{
get.qc.barplot(
  quality.scores,
  filename = NULL,
  abline.h = -20,
  yaxis.cex = 0.8,
  xaxis.cex = 0,
  yaxis.tck = 1,
  xaxis.tck = 0,
  xlab.label = "",
  ylab.label = "Sum of Z (Z < 0)",
  ylab.cex = 1,
  abline.col = "darkgrey",
  axes.lwd = 1,
  ...
)
}
\arguments{
\item{quality.scores}{A dataframe with columns 'Sum' (of scores) and 'Sample', i.e. the output of accumulate.zscores}

\item{filename}{Filename for tiff output, or if NULL returns the trellis object itself}

\item{abline.h}{Adds a horizontal line to the plot; useful for depicting the threshold for what is deemed a poor sample quality score}

\item{yaxis.cex}{Size of y-axis tick labels, defaults to 0.8}

\item{xaxis.cex}{Size of x-axis tick labels, defaults to 0}

\item{yaxis.tck}{Specifies the length of the tick marks for y-axis, defaults to 1}

\item{xaxis.tck}{Specifies the length of the tick marks for x-axis, defaults to 0}

\item{xlab.label}{The label for the x-axis, defaults to ''}

\item{ylab.label}{label for the y-axis, defaults to 'Sum of Z (Z < 0)'}

\item{ylab.cex}{Size of y-axis label, defaults to 1}

\item{abline.col}{Colour of the horizontal line on the plot, defaults to 'darkgrey'}

\item{axes.lwd}{Specify line width of the axes; set to 0 to turn off axes}

\item{...}{The function can also take any parameter that BoutrosLab.plotting.general::create.barplot takes}
}
\value{
The barplot or NULL depending if filename is specified
}
\description{
This function takes the quality score data generated by accumulate.zscores()
and returns the barplot if no filename is specified. If filename is
is specified it saves the plot as file and returns NULL. It will also draw a
cut-off for which samples to exclude. get.qc.barplot offers a standard template for generating
a QC barplot, but can also take any parameter that BoutrosLab.plotting.general::create.barplot
takes for more customizability.
}
