/*
 * Decompiled with CFR 0.152.
 */
package org.andwellness.xml.datagenerator.creator;

import java.util.Map;
import nu.xom.Node;
import org.andwellness.xml.datagenerator.creator.DataPointCreator;
import org.andwellness.xml.datagenerator.model.DataPoint;
import org.andwellness.xml.datagenerator.utility.ValueCreator;

public class NumberDataPointCreator
extends DataPointCreator {
    @Override
    public DataPoint create(Node currentNode) {
        String displayType = currentNode.query("displayType").get(0).getValue();
        String nodeId = currentNode.query("id").get(0).getValue();
        DataPoint createdDataPoint = new DataPoint();
        createdDataPoint.setId(nodeId);
        createdDataPoint.setPromptType(DataPoint.PromptType.number);
        createdDataPoint.setDisplayType(displayType);
        Node propertyNode = currentNode.query("properties").get(0);
        Map<String, String> nodeProperties = this.extractProperties(propertyNode);
        long min = Long.decode(nodeProperties.get("min"));
        long max = Long.decode(nodeProperties.get("max"));
        long number = ValueCreator.randomPositiveLongModulus(max - min + 1L) + min;
        createdDataPoint.setValue(new Long(number));
        if (this._logger.isDebugEnabled()) {
            this._logger.debug("Creating a number data point with id " + nodeId + " min " + min + " max " + max + " value " + number);
        }
        return createdDataPoint;
    }
}

