% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SegFunctions.R
\name{Eta2}
\alias{Eta2}
\title{A function to compute adjusted isolation index (Eta2)}
\usage{
Eta2(x)
}
\arguments{
\item{x}{- an object of class matrix (or which can be coerced to that class), 
where each column represents the distribution of a population group, within 
spatial units. The number of columns should be greater than 1 (at least 2 
population groups are required). You should not include a column with total 
population in each unit, because this will be interpreted as a group.}
}
\value{
a numeric vector containing the adjusted isolation index value for 
each population group
}
\description{
The adjusted isolation index is the standardized 
version of the isolation index, \code{\link{xPx}}, which 
controls for the effect of total population structure. Using 
the approximate version of xPx, the adjusted index is equal 
to Eta2 (the square of the correlation ratio) which, in the 
case of the binomial variable, is identical to the square of 
the mean square contingency coefficient phi. It can be used 
as a segregation score and varies from 0 (minimum segregation) 
to 1 (maximum segregation).
}
\examples{
x <- segdata@data[ ,1:2]
Eta2(x) 
}
\references{
Bell W. (1954) \emph{A probability model for the 
measurement of ecological segregation}. Social Forces 32(4), 
pp. 357-364

Duncan O. D. and Duncan B. (1955) \emph{ 
Residential Distribution and Occupational Stratification.}. 
American Journal of Sociology 60 (5), pp. 493-503
}
\seealso{
Isolation indices: 
\code{\link{xPx}},  \code{\link{DPxx}}

Interaction indices: 
\code{\link{xPy}}, \code{\link{DPxy}}
}

