% Generated by roxygen2 (4.1.0): do not edit by hand
% Please edit documentation in R/SegFunctions.R
\name{RelDivers}
\alias{RelDivers}
\title{A function to compute multigroup relative diversity index}
\usage{
RelDivers(x)
}
\arguments{
\item{x}{- an object of class matrix (or that can be coerced
to that class), where each column represents the distribution
of a population group, within spatial units. The number of
columns should be greater than one (at least two population
groups are required).}
}
\value{
Multigroup relative diversity index
}
\description{
Multigroup index based on Simpson's interaction
index \code{\link{ISimpson}}
}
\examples{
x <- slot(GreHSize, 'data')[ ,3:5]
RelDivers(x)
}
\references{
Carlson S. M. (1992) \emph{Trends in race/sex
occupational inequality:  conceptual and measurement issues}.
Social Problems, 39, p. 269-290
}
\seealso{
Other multigroup exposition indices:  \code{\link{PIsol}}

Other multigroup indices: \code{\link{HShannon}},
\code{\link{JPielou}}, \code{\link{ISimpson}}, \code{\link{GiniMulti}},
\code{\link{DMulti}}
}

