% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/import_old_readers.R
\name{import_old_readers}
\alias{import_old_readers}
\title{Import from previous generations of Oregon RFID antenna readers}
\usage{
import_old_readers(file, delim, verbose = FALSE)
}
\arguments{
\item{file}{.txt file generated by an Oregon RFID reader.}

\item{delim}{field/column delimiter, which must be tab ('\\t'), comma (',') or semi-colon (';').}

\item{verbose}{If \emph{TRUE}, a description of the compiled data is printed to the console.}
}
\value{
Returns a tibble object.
}
\description{
Only data collected using Oregon RFID (radio-frequency identification) ORMR (Oregon RFID Multi-Reader) and ORSR (Oregon RFID Single Reader) antenna readers can be imported using \code{\link{import_ORFID}}. Data from previous generations of readers must be imported using \code{\link{import_old_readers}}. Only detections are retained during compilation (events are removed).

This function will only work with raw data downloaded directly from Oregon RFID stationary readers. The files must be delimited (tab, comma, or semicolon) and unedited by the user.
}
\details{
The field/column delimiter must be tab, comma or semi-colon for data compilation and further analysis. The function cannot be used for space delimited data. 

Data compiled using \code{\link{import_ORFID}} and \code{\link{import_old_readers}} can be joined together using \code{\link{join_multireader_data}}.

Note that corruption may occur in reader data files. Check your data files and compiled data carefully to ensure accuracy.
}
\examples{

# Import a single comma-deliminated data file from an old ORFID reader
import_old_readers(file = system.file("extdata/orfid_old_data_file.txt", 
package = "ORFID"), delim = ",")

}
\author{
Hugo Marques <biohmarques@gmail.com>
}
