% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pathlengths.R
\name{pathlengths}
\alias{pathlengths}
\title{Characteristic Path Lengths}
\usage{
pathlengths(A, weighted = FALSE)
}
\arguments{
\item{A}{An adjacency matrix of network data}

\item{weighted}{Is the network weighted?
Defaults to \code{FALSE}.
Set to \code{TRUE} for weighted measures}
}
\value{
Returns a list containing:

\item{ASPL}{Global average shortest path length}

\item{ASPLi}{Local average shortest path length}

\item{ecc}{Eccentricity (i.e., maximal shortest path length between a node and any other node)}

\item{D}{Diameter of the network (i.e., the maximum of eccentricity)}
}
\description{
Computes global average shortest path length,
local average shortest path length, eccentricity,
and diameter of a network
}
\examples{
# Pearson's correlation only for CRAN checks
A <- TMFG(neoOpen, normal = FALSE)$A

#Unweighted
PL <- pathlengths(A)

#Weighted
PL <- pathlengths(A, weighted = TRUE)

}
\references{
Rubinov, M., & Sporns, O. (2010). 
Complex network measures of brain connectivity: Uses and interpretations. 
\emph{Neuroimage}, \emph{52}, 1059-1069.
}
\author{
Alexander Christensen <alexpaulchristensen@gmail.com>
}
