% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/comm.eigen.R
\name{comm.eigen}
\alias{comm.eigen}
\title{Community Eigenvector Centrality}
\usage{
comm.eigen(A, comm, weighted = TRUE)
}
\arguments{
\item{A}{An adjacency matrix}

\item{comm}{A vector or matrix corresponding to the
community each node belongs to}

\item{weighted}{Is the network weighted?
Defaults to \code{TRUE}.
Set to \code{FALSE} for weighted measures}
}
\value{
A vector of community eigenvector centrality values for
each specified community in the network
(larger values suggest more central positioning)
}
\description{
Computes the \link[NetworkToolbox]{flow.frac} for each
community in the network. The values are equivalent to the community's
eigenvector centrality
}
\examples{
# Pearson's correlation only for CRAN checks
A <- TMFG(neoOpen, normal = FALSE)$A

comm <- igraph::walktrap.community(convert2igraph(abs(A)))$membership

result <- comm.eigen(A, comm)

}
\references{
Giscard, P. L., & Wilson, R. C. (2018).
A centrality measure for cycles and subgraphs II.
\emph{Applied Network Science}, \emph{3}, 9.
doi: \href{https://doi.org/10.1007/s41109-018-0064-5}{10.1007/s41109-018-0064-5}
}
\author{
Alexander Christensen <alexpaulchristensen@gmail.com>
}
