% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/node.multidimensional.R
\name{node.multidimensional}
\alias{node.multidimensional}
\title{Detects Node Crossings in a Network}
\usage{
node.multidimensional(A, comm, plot = FALSE)
}
\arguments{
\item{A}{An adjacency matrix of network data}

\item{comm}{A vector or matrix corresponding to the
community each node belongs to}

\item{plot}{Should a plot be produced?}
}
\value{
Produces a list containing:
}
\description{
UNDER DEVELOPMENT.
Computes \code{\link[NetworkToolbox]{rspbc}} for connections
between dimensions in a network. Multidimensional nodes can be detected
}
\examples{
# Uses Pearson's correlation 
tmfg <- TMFG(neoOpen)$A

\dontrun{
# Better to use polychoric correlations with this dataset
ega.glasso <- EGAnet::EGA(neoOpen)

result <- node.multidimensional(A = ega.glasso$network, comm = ega.glasso$wc, plot = FALSE)

}

}
\author{
Alexander Christensen <alexpaulchristensen@gmail.com>
}
