% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/edgerep.R
\name{edgerep}
\alias{edgerep}
\title{Edge Replication}
\usage{
edgerep(A, B, corr = c("pearson", "spearman", "kendall"))
}
\arguments{
\item{A}{An adjacency matrix of network A}

\item{B}{An adjacency matrix of network B}

\item{corr}{Correlation method for assessing the relatonship between the replicated edge weights.
Defaults to "pearson".
Set to "spearman" for non-linear or monotonic associations.
Set to "kendall" for rank-order correlations}
}
\value{
Returns a list containing:

\item{replicatedEdges}{The edges that replicated and their weights}

\item{replicated}{Number of edges that replicated}

\item{meanDiff}{The average edge weight difference between the edges that replicated}

\item{sdDiff}{The standard deviation edge weight difference between the edges that replicated}

\item{cor}{The correlation between the edges that replicated}

Lists for each network contain:

\item{totalEdges}{Total possible number of edges to be replicated}

\item{percentage}{Percentage of edges that replicated relative to total possible}

\item{density}{The density of the network}
}
\description{
Computes the number of edges that replicate between two cross-sectional networks
}
\examples{
tmfg <- TMFG(neoOpen)$A

mast <- MaST(neoOpen)

edges <- edgerep(tmfg, mast)

}
\author{
Alexander Christensen <alexpaulchristensen@gmail.com>
}
