% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/NetworkToolbox--master.R
\name{transitivity}
\alias{transitivity}
\title{Transitivity}
\usage{
transitivity(A, weighted = FALSE)
}
\arguments{
\item{A}{An adjacency matrix of network data}

\item{weighted}{Is the network weighted?
Defaults to FALSE.
Set to TRUE for a weighted measure of transitivity}
}
\value{
Returns a value of transitivity
}
\description{
Computes transitivity of a network
}
\examples{
A<-TMFG(neoOpen)$A

trans<-transitivity(A, weighted=TRUE)
}
\references{
Rubinov, M., & Sporns, O. (2010). 
Complex network measures of brain connectivity: Uses and interpretations. 
\emph{Neuroimage}, \emph{52}(3), 1059-1069.
}
\author{
Alexander Christensen <alexpaulchristensen@gmail.com>
}
