% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/NetworkToolbox--master.R
\name{threshold}
\alias{threshold}
\title{Threshold Filter}
\usage{
threshold(data, binary = FALSE, thresh = 0.1, a = 0.05)
}
\arguments{
\item{data}{Can be a dataset or a correlation matrix}

\item{binary}{Is dataset dichotomous? Defaults to FALSE. Set TRUE if dataset is dichotomous (tetrachoric correlations are computed)}

\item{thresh}{Sets threshold (defaults to \emph{r} = .10). Set to "alpha" to use an alpha value, "bonferroni" for the bonferroni correction, and "FDR" for false discovery rate}

\item{a}{Defaults to .05. Applied when thresh = "alpha" and "bonferroni"}
}
\value{
Returns a list containing a filtered adjacency matrix (A) and the critical r value (r.cv)
}
\description{
Filters the network based on an r-value or alpha
}
\examples{

threshnet<-threshold(hex)

alphanet<-threshold(hex, thresh = "alpha")

}
\author{
Alexander Christensen <alexpaulchristensen@gmail.com>
}
