% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/NetworkToolbox--master.R
\name{MaST}
\alias{MaST}
\title{Maximum Spanning Tree}
\usage{
MaST(data, binary = FALSE, weighted = TRUE, depend = FALSE)
}
\arguments{
\item{data}{Can be a dataset or a correlation matrix}

\item{binary}{Is dataset dichotomous? Defaults to FALSE. Set TRUE if dataset is dichotomous (tetrachoric correlations are computed)}

\item{weighted}{Should network be weighted? Defaults to TRUE. Set FALSE to produce an unweighted (binary) network}

\item{depend}{Is network a dependency (or directed) network? Defaults to FALSE. Set TRUE to generate a MaST-filtered dependency network}
}
\value{
A sparse association matrix
}
\description{
Applies the Maximum Spanning Tree (MaST) filtering method
}
\examples{
weighted_MaSTnetwork<-MaST(hex)

weighted_binary_MaSTnetwork<-MaST(hexb,binary=TRUE)

unweighted_MaSTnetwork<-MaST(hex,weighted=FALSE)

unweighted_binary_MaSTnetwork<-MaST(hexb,binary=TRUE,weighted=FALSE)
}
\references{
Adapted from: \url{https://www.mathworks.com/matlabcentral/fileexchange/23276-maximum-weight-spanning-tree--undirected}
}
\author{
Alexander Christensen <alexpaulchristensen@gmail.com>
}
