% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/netfacs.R
\name{netfacs}
\alias{netfacs}
\title{Create probability distribution of combinations of elements in the data}
\usage{
netfacs(
  data,
  condition = NULL,
  test.condition = NULL,
  null.condition = NULL,
  duration = NULL,
  ran.trials = 1000,
  control = NULL,
  random.level = NULL,
  combination.size = 2,
  tail = "upper.tail",
  use_parallel = TRUE,
  n_cores = 2
)
}
\arguments{
\item{data}{A binary matrix with one column per element, and one row per
event, consisting of 1 (element was active during that event) and 0
(element was not active).}

\item{condition}{A character vector the same length as 'data' that contains
information on the condition each event belongs to, so probabilities can be
compared across conditions; if NULL, all events will be tested against a
random null condition based on permutations.}

\item{test.condition}{A string, indicating the level of 'condition' that is
supposed to be tested.}

\item{null.condition}{A string, indicating the level of 'condition' that is
used to create the null distribution of values; if NULL, all levels that
are not the test condition will be used.}

\item{duration}{A numeric vector that contains information on the duration of
each event; if NULL, all events are assumed to have equal duration.}

\item{ran.trials}{Number of randomisations that will be performed to find the
null distribution.}

\item{control}{A list of vectors that are used as control variables. During
bootstraps, the ratio of events in each level will be adapted. So, for
example, if in the test distribution, there are three angry participants
for each happy participant, the null distribution will maintain that ratio.}

\item{random.level}{A character vector of the level on which the
randomization should take place. If NULL, the randomization takes place on
the event level (i.e., every row can either be selected or not); if a
vector is provided, the randomization takes place on the levels of that
vector rather than individual events.}

\item{combination.size}{A positive integer, indicating the maximum
combination size of element combinations. Higher numbers will increase
computation time. Default is 2.}

\item{tail}{Either 'upper.tail' (proportion of null probabilities that are
larger than observed probabilities), or 'lower.tail' (proportion of null
probabilities that are smaller than observed probabilities); default is
'upper.tail'.}

\item{use_parallel}{Logical, indicating whether randomization or bootstrap
should be parallelized (default is \code{TRUE})}

\item{n_cores}{Numeric, indicating the number cores to be used for
parallelization. Default is 2.}
}
\value{
An object of class \code{netfacs}, which contains the probabilities
  of observing element combinations in the data, along with other useful
  information. The resulting object is the basis for most other functions in
  this package.
}
\description{
The \code{\link{netfacs}} function underlies most other functions in this
package. \cr It takes the data set and reports the observed and expected
probabilities that elements and combinations of elements occur in this data
set, and whether this differs from a null condition.
}
\details{
If the 'condition' and 'test.condition' arguments are specified, the
  null distribution of probability values are based on bootstraps of the null
  condition. If the 'condition' argument is not specified, the null
  distribution is based on random permutations of the data.

  For a general overview on how to use the netfacs function and package see
  \code{vignette("netfacs_tutorial")}.
}
\examples{
### how do angry facial expressions differ from non-angry ones?
\donttest{
data(emotions_set)
angry.face <- netfacs(
  data = emotions_set[[1]],
  condition = emotions_set[[2]]$emotion,
  test.condition = "anger",
  null.condition = NULL,
  duration = NULL,
  ran.trials = 100,
  control = NULL,
  random.level = NULL,
  combination.size = 5,
  tail = "upper.tail",
  use_parallel = TRUE,
  n_cores = 2
)

head(angry.face$result, 20)
angry.face$event.size.information
}

}
\references{
Mielke, A., Waller, B. M., Perez, C., Rincon, A. V., Duboscq, J.,
  & Micheletta, J. (2021). NetFACS: Using network science to understand
  facial communication systems. \emph{Behavior Research Methods}.
  \code{https://doi.org/10.3758/s13428-021-01692-5}
}
\seealso{
\code{\link{netfacs_multiple}}, \code{\link{netfacs_extract}},
  \code{\link{conditional_probabilities}}
}
\author{
Alex Mielke, Alan V. Rincon
}
