% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/netfacs_extract.R
\name{netfacs_extract}
\alias{netfacs_extract}
\title{Extract results from a netfacs object}
\usage{
netfacs_extract(
  netfacs.data,
  combination.size = NULL,
  significance = 1,
  min.count = 0,
  min.prob = 0,
  min.specificity = 0
)
}
\arguments{
\item{netfacs.data}{object resulting from \code{\link{netfacs}} function.}

\item{combination.size}{numeric, denoting the combination size(s) that should
be extracted. If NULL (default), all combination sizes are returned.}

\item{significance}{numeric value between 0 and 1, determining the p-value
below which combinations are considered to be dissimilar enough from the
null distribution.}

\item{min.count}{numeric value, suggesting how many times a combination
should at least occur to be displayed.}

\item{min.prob}{numeric value between 0 and 1, suggesting the probability at
which a combination should at least occur to be displayed.}

\item{min.specificity}{numeric value between 0 and 1, suggesting the
specificity a combination should at least have for the test condition to be
displayed.}
}
\value{
Function returns a dataframe that contains the results of the
  \code{\link{netfacs}} object. By default, returns all results for all
  observed combinations
}
\description{
Extract results from a \code{\link{netfacs}} object.
}
\examples{
### how do angry facial expressions differ from non-angry ones?
data(emotions_set)
angry.face <- netfacs(
  data = emotions_set[[1]],
  condition = emotions_set[[2]]$emotion,
  test.condition = "anger",
  ran.trials = 100,
  combination.size = 2
)

netfacs_extract(angry.face,
  combination.size = 2,
  significance = 0.01,
  min.count = 5,
  min.prob = 0.01,
  min.specificity = 0.5
)
}
