% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/NMDS.R
\name{runNMDS}
\alias{runNMDS}
\alias{runNMDS.data.frame}
\alias{runNMDS.matrix}
\alias{runNMDS.default}
\title{Non-Metric Multidimensional Scaling (NMDS) Analysis}
\usage{
runNMDS(
  data,
  group,
  distance = "bray",
  k = 2,
  decostand.method = "hellinger",
  autotransform = TRUE,
  adonis2 = TRUE,
  anosim = TRUE,
  simper = TRUE,
  ...
)

\method{runNMDS}{data.frame}(
  data,
  group,
  distance = "bray",
  k = 2,
  decostand.method = "hellinger",
  autotransform = TRUE,
  adonis2 = TRUE,
  anosim = TRUE,
  simper = TRUE,
  ...
)

\method{runNMDS}{matrix}(
  data,
  group,
  distance = "bray",
  k = 2,
  decostand.method = "hellinger",
  autotransform = TRUE,
  adonis2 = TRUE,
  anosim = TRUE,
  simper = TRUE,
  ...
)

\method{runNMDS}{default}(
  data,
  group,
  distance = "bray",
  k = 2,
  decostand.method = "hellinger",
  autotransform = TRUE,
  adonis2 = TRUE,
  anosim = TRUE,
  simper = TRUE,
  ...
)
}
\arguments{
\item{data}{\code{data.frame} or \code{matrix}. The nematode abundance table where rows represent samples and columns represent nematode genera.
Each element indicates the count of a specific nematode genus in the corresponding sample. Row names must be sample names.}

\item{group}{\code{data.frame}. A data frame with sample names as row names and a single column containing group information for each sample.}

\item{distance}{Distance metric to use (default: "bray"). See \code{\link[vegan]{metaMDS}} for all available options.}

\item{k}{Number of dimensions for NMDS (default: 2).}

\item{decostand.method}{Standardization methods for community ecology data (default: "hellinger"). Set to \code{NULL} for no transformation. See \code{\link[vegan]{decostand}} for all available options.}

\item{autotransform}{Logical; whether to automatically transform the data (default: TRUE).
See \code{\link[vegan]{metaMDS}} for details.}

\item{adonis2}{Logical; whether to perform PERMANOVA test using \code{\link[vegan]{adonis2}} (default: TRUE).}

\item{anosim}{Logical; whether to perform ANOSIM test using \code{\link[vegan]{anosim}} (default: TRUE).}

\item{simper}{Logical; whether to perform SIMPER test using \code{\link[vegan]{simper}} (default: TRUE).}

\item{...}{Additional arguments passed to \code{\link[vegan]{metaMDS}}, \code{\link[vegan]{decostand}}, \code{\link[vegan]{adonis2}}, \code{\link[vegan]{anosim}}, or \code{\link[vegan]{simper}}.}
}
\value{
An object of class "NMDS" containing:
\itemize{
\item data - List containing the input data and group information
\item call - The function call
\item NMDS - NMDS results from \code{\link[vegan]{metaMDS}}
\item adonis2 - PERMANOVA results (if adonis2 = TRUE)
\item anosim - ANOSIM results (if anosim = TRUE)
\item SIMPER - SIMPER results (if simper = TRUE)
}
}
\description{
This function performs NMDS analysis on a dataset using the specified distance metric,
and optionally runs PERMANOVA (adonis2) and ANOSIM tests for group differences.
It supports both data.frame and matrix inputs.
}
\examples{
# Example with default Bray-Curtis distance
data <- data.frame(
  Cephalobus = c(10, 20, 30, 1, 6, 5),
  Eucephalobus = c(5, 10, 12, 30, 1, 6),
  Acrobeloides = c(1, 2, 3, 12, 30, 1),
  Caenorhabditis = c(5, 8, 15, 2, 3, 12),
  Aphelenchus = c(5, 13, 11, 15, 2, 3),
  Leptonchus = c(3, 10, 15, 0, 15, 11),
  Pratylenchus = c(9, 2, 15, 15, 0, 15),
  Tylenchus = c(5, 0, 15, 11, 15, 2),
  Mesodorylaimus = c(7, 10, 18, 3, 12, 30),
  Discolaimus = c(1, 10, 25, 10, 18, 3),
  row.names = c("Sample1", "Sample2", "Sample3", "Sample4", "Sample5", "Sample6")
)
group_df <- data.frame(
  group = c("A", "A", "B", "B", "C", "C"),
  row.names = c("Sample1", "Sample2", "Sample3", "Sample4", "Sample5", "Sample6")
)

nmds <- runNMDS(data, group = group_df)

}
\seealso{
\itemize{
\item \code{\link[vegan]{metaMDS}} for details on NMDS implementation and distance measures
\item \code{\link[vegan]{decostand}} for details on standardization methods
\item \code{\link[vegan]{vegdist}} for available distance metrics
\item \code{\link[vegan]{adonis2}} for PERMANOVA
\item \code{\link[vegan]{anosim}} for ANOSIM
\item \code{\link[vegan]{simper}} for SIMPER
}
}
