% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/NatParksPalettes.R
\name{display_all}
\alias{display_all}
\title{View all Palettes available}
\usage{
display_all(
  n,
  sequential = FALSE,
  colorblind_only = FALSE,
  direction = 1,
  override.order = FALSE
)
}
\arguments{
\item{n}{Number of requested colors. If n is left blank, default palette is returned.}

\item{sequential}{Should palettes displayed all at once, or one at a time. Default is all at once (FALSE).}

\item{colorblind_only}{Should only colorblind friendly palettes be returned? Default is set to FALSE.}

\item{direction}{Sets order of colors. Default palette is 1. If direction is -1, palette color order is reversed}

\item{override.order}{Colors are picked from palette to maximize readability and aesthetics. This means
that colors are not always selected in sequential order from the full palette. If override.order is set to TRUE,
colors are selected in sequential order from the full palette instead. Default is FALSE.}
}
\value{
Plot of all color palettes available
}
\description{
Function for viewing all palettes available in NatParksPalettes.
}
\examples{
# All Palettes
display_all(sequential = FALSE, colorblind_only = FALSE)

# All Colorblind Palettes
display_all(sequential = FALSE, colorblind_only = TRUE)

# 5 Colors of all Palettes
display_all(5, sequential = FALSE, colorblind_only = FALSE)
}
