% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/runNUCOM.r
\name{runNUCOM}
\alias{runNUCOM}
\title{Run NUCOMBog}
\source{
The executable of the model can downloaded from \url{https://github.com/jeroenpullens/source_modelMEE}
}
\usage{
runNUCOM(setup, parameters = NULL)
}
\arguments{
\item{setup}{The setup structure created by setup_NUCOM function needs to be inserted here, for more information see the setup_NUCOM function help, by typing "?NUCOMBog::setup_NUCOM".}

\item{parameters}{The parameters which are used in the model. If no parameter values are given the default values will be used. The parameters have to have the format of a dataframe with colum names: "names" and "values".
See example data available at \url{https://github.com/jeroenpullens/NUCOMBog_data}. The default parameters are from Heijmans et al. 2008.}
}
\description{
Code to run NUCOMBog on a single core.
}
\examples{
\dontrun{
names<-c("CO2ref","gram_Beta","eric_MaxGr")
initialParameters <- c(380,0.5,65)
initialParameters<-data.frame(names,initialParameters)
names(initialParameters)<-c("names","values")

runNUCOM(setup = test_setup_singlecore,parameters=initialParameters)

## with predefined parameters:
runnucom(setup = test_setup_singlecore,parameters=NULL)
}
}
\author{
JWM Pullens
}
\references{
Heijmans, M., Mauquoy, D., van Geel, B., and Berendse, F. (2008). Long-term effects of climate change on vegetation and carbon dynamics in peat bogs. Journal of Vegetation Science, 19(3)
}

