% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hello.R
\name{SMC.Full}
\alias{SMC.Full}
\title{Generic Sequential Monte Carlo Using Full Information Proposal Distribution}
\usage{
SMC.Full(SISstep.Full, nobs, yy, mm, par, xx.init, xdim, ydim,
  resample.sch, delay = 0, funH = identity)
}
\arguments{
\item{SISstep.Full}{a function that performs one step propagation using a proposal distribution.
Its input includes \code{(mm,xx,logww,yyy,par,xdim,ydim,resample)}, where
\code{xx} and \code{logww} are the last iteration samples and log weight. \code{yyy} is the
observation at current time step. It should return \code{xx} (the samples xt) and
\code{logww} (their corresponding log weight), \code{resample} is a binary value for resampling.}

\item{nobs}{the number of observations \code{T}.}

\item{yy}{the observations with \code{T} columns and \code{ydim} rows.}

\item{mm}{the Monte Carlo sample size \code{m}.}

\item{par}{a list of parameter values to pass to \code{Sstep}.}

\item{xx.init}{the initial samples of \code{x_0}.}

\item{xdim}{the dimension of the state varible \code{x_t}.}

\item{ydim}{the dimension of the observation \code{y_t}.}

\item{resample.sch}{a binary vector of length \code{nobs}, reflecting the resampling schedule. resample.sch[i]= 1 indicating resample should be carried out at step \code{i}.}

\item{delay}{the maximum delay lag for delayed weighting estimation. Default is zero.}

\item{funH}{a user supplied function \code{h()} for estimation \code{E(h(x_t) | y_t+d}). Default
is identity for estimating the mean. The function should be able to take vector or matrix as input and operates on each element of the input.}
}
\value{
The function returns a list with the following components:
\item{xhat}{the fitted values.}
\item{loglike}{the log-likelihood.}
}
\description{
Generic sequential Monte Carlo using full information proposal distribution.
}
\references{
Tsay, R. and Chen, R. (2018). Nonlinear Time Series Analysis. John Wiley & Sons, New Jersey.
}
