\name{SimulateIP}
\alias{SimulateIP}
\title{Simulation of the Inverse-Power Type Model}
\description{
  Simulation of the Inverse-power type model.
}
\usage{
  SimulateIP(pars, seed = NULL, plot = TRUE)
}
\arguments{
  \item{pars}{a named vector of containing the values of the model parameters
    (\code{mu}, \code{nu}, \code{p}, \code{c}), where \code{mu} is an intensity
    of parents, \code{nu} is an expected number of descendants for each parent,
    \code{p} is the decay order and \code{c} is the scaling parameter.}
  \item{seed}{a positive integer, which is the seed for a sequence of uniform
    random numbers. The default seed is based on the current time.}
  \item{plot}{logical. If \code{TRUE} (default), simulated parent points and
    offspring points are plotted.}
}
\details{
  Let random variable \eqn{U} be independently and uniformly distributed in [0,1].

  For all \eqn{r \ge 0}{r>=0},

  \deqn{Q_{p,c}(r) := \int_0^r q_{p,c}(t)dt}{%
        Q_{p,c}(r) := integral_0^r q_{p,c}(t)dt}
  \deqn{= c^{p-1}(p-1) \frac{(r+c)^{1-p} - c^{1-p}}{1-p}}{%
        = c^{p-1} (p-1) {(r+c)^{1-p} - c^{1-p}}/(1-p)}
  \deqn{= 1 - c^{p-1} (r+c)^{1-p}.}{%
        = 1 - c^{p-1} (r+c)^{1-p}.}

  Here, we put \eqn{Q_{p,c}(r) = U}. From this, we have

  \deqn{r = c\{(1-U)^{1/(1-p)} - 1\}.}{%
        r = c {(1-U)^{1/(1-p)} - 1}.}

  Let \eqn{(x_i^p, y_i^p), i=1,2,\dots, I} be a coordinate of each parent point
  where the integer \eqn{I} is generated from the Poisson random variable
  \eqn{Poisson(\mu)} with mean \eqn{\mu} from now on. Then, for each \eqn{i},
  the number of offspring \eqn{J_i} is generated by the random variable
  \eqn{Poisson(\nu)} with mean \eqn{\nu}. Then, using series of different
  uniform random numbers \eqn{\{U\}}{{U}} for different \eqn{i} and \eqn{j},
  each of the offspring coordinates \eqn{(x_j^i, y_j^i), j=1,2,\dots,J_i} is
  given by

  \deqn{x_j^i = x_i^p + r \cos(2 \pi U),}{%
        x_j^i = x_i^p + r cos(2\piU),}
  \deqn{y_j^i = y_i^p + r \sin(2 \pi U),}{%
        y_j^i = y_i^p + r sin(2\piU),}

  owing to the isotropy condition of the distribution.

  Given a positive number \eqn{\nu} and let a sequence of a random variable
  \eqn{\{U_k\}}{{Uk}} be independently and uniformly distributed in [0,1],
  the Poisson random number \eqn{M} is the smallest integer such that

  \deqn{\sum_{k=1}^{M+1} - \log U_k > \nu,}{\sum_{k=1}^{M+1} - log Uk > \nu,}

  where \eqn{\log}{log} represents natural logarithm.
}
\value{
  \item{parents}{a list containing two components named "\code{n}" and
    "\code{xy}" giving the number and the matrix of \code{(x,y)} coordinates of
    simulated parents points respectively.}
  \item{offspring}{a list containing two components named "\code{n}" and
    "\code{xy}" giving the number and the matrix of \code{(x,y)} coordinates of
     simulated offspring points respectively.}
}
\references{
  U. Tanaka, Y. Ogata and K. Katsura,
  Simulation and estimation of the Neyman-Scott type spatial cluster models,
  \emph{Computer Science Monographs} \bold{No.34}, 2008, 1-44.
  The Institute of Statistical Mathematics.
}
\examples{
pars <- c(mu = 50.0, nu = 30.0, p = 1.5, c = 0.005)
SimulateIP(pars, seed = 353)
}

\keyword{spatial}
