% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SD_Efficient_Set.R
\name{NNS.SD.Efficient.Set}
\alias{NNS.SD.Efficient.Set}
\title{NNS SD Efficient Set}
\usage{
NNS.SD.Efficient.Set(A, degree)
}
\arguments{
\item{A}{data.frame of variables.}

\item{degree}{Degree of stochastic dominance test}
}
\value{
Returns set of stochastic dominant variable names.
}
\description{
Determines the set of stochastic dominant variables for various degrees.
}
\examples{
set.seed(123)
x<-rnorm(100); y<-rnorm(100); z<-rnorm(100)
A<-data.frame(x,y,z)
NNS.SD.Efficient.Set(A,1)
}
\author{
Fred Viole, OVVO Financial Systems
}
\references{
Viole, F. and Nawrocki, D. (2016) "LPM Density Functions for the Computation of the SD Efficient Set." Journal of Mathematical Finance, 6, 105-126. \url{http://www.scirp.org/Journal/PaperInformation.aspx?PaperID=63817}.
}
\keyword{dominance}
\keyword{stochastic}

