% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mergeCheck.R
\name{mergeCheck}
\alias{mergeCheck}
\title{Merge, order, and check resulting rows and columns.}
\usage{
mergeCheck(
  df1,
  df2,
  by,
  fun.commoncols = base::warning,
  ncols.expect,
  track.msg = FALSE,
  quiet,
  as.fun,
  ...
)
}
\arguments{
\item{df1}{A data.frame with the number of rows must should be
obtained from the merge. The resulting data.frame will be
ordered like df1.}

\item{df2}{A data.frame that will be merged onto df1.}

\item{by}{The column(s) to merge by. Character string
(vector). by or by.x and by.y must be supplied.}

\item{fun.commoncols}{If common columns are found in df1 and df2,
and they are not used in by, this will create columns named
like col.x and col.y in result (see ?merge). Often, this is a
mistake, and the default is to throw a warning if this
happens. If using mergeCheck in a function, you may want to
make sure this is not happening and use
fun.commoncols=stop. If you want nothing to happen, you can do
fun.commoncols=NULL.}

\item{ncols.expect}{If you want to include a check of the number
of columns being added to the dimensions of df1. So if
ncols.expect=1, the resulting data must have exactly one
column more than df1 - if not, an error will be returned.}

\item{track.msg}{If using mergeCheck inside other functions, it
can be useful to use track.msg=TRUE. This will add information
to messages/warnings/errors that they came from mergCheck.}

\item{quiet}{If FALSE, the names of the added columns are
reported. Default value controlled by NMdataConf.}

\item{as.fun}{The default is to return a data.table if df1 is a
data.table and return a data.frame in all other cases. Pass a
function in as.fun to convert to something else.}

\item{...}{additional arguments passed to data.table::merge. If
all is among them, an error will be returned.}
}
\value{
a data.frame resulting from merging df1 and df2. Class as
    defined by as.fun.
}
\description{
This function is a useful wrapper for merges where df1 will be
extended with columns from df2, i.e. all rows in df1 are retained,
and no new rows can be created. For this very common type of
(simple) merges, mergeCheck does the merge and ensures that
exactly this and nothing else happened. Notice, mergeCheck passes
the hard work to merge.data.table, the contributions lies in
checking that the results are consistent with the simple merge
described above.
}
\details{
Besides merging and checking rows, mergeCheck makes sure
    the order in df1 is retained in the resulting data. Also, a
    warning is given if column names are overlapping, making merge
    create new column names like col.x and col.y. Merges and other
    operations are done using data.table. If df1 is a data.frame
    (and not a data.table), it will internally be converted to a
    data.table, and the resulting data.table will be converted
    back to a data.frame before returning.
}
\seealso{
Other DataCreate: 
\code{\link{NMorderColumns}()},
\code{\link{NMstamp}()},
\code{\link{findCovs}()},
\code{\link{findVars}()},
\code{\link{flagsAssign}()},
\code{\link{flagsCount}()},
\code{\link{tmpcol}()}
}
\concept{DataCreate}
