% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/predict-edge.R
\name{predictEdge}
\alias{predictEdge}
\title{Edge prediction of weighted bipartite network.}
\usage{
predictEdge(inc_mat, method = c("svd", "median", "als", "CA"))
}
\arguments{
\item{inc_mat}{An incidence matrix containing missing values (edge weights), represented by NAs.}

\item{method}{A string or list of string. By default, it is set to this list: \code{c("svd", "median", "als", "CA")}. Other available methods in \code{MICE}, \code{knn}, \code{FAMD}, \code{PCA}, and \code{pmm}, can be called to perform at a single step.}
}
\value{
A list of matrices with original and imputed values by different methods.
}
\description{
This function utilizes several data imputation methods in order to predict the existence of a link between two nodes by imputing the edges' weight in a weighted bipartite network of nominal data.
}
\details{
This function performs a variety of numerical imputation according to the user's input, and returns a list of imputed data matrices based on each method separately, such as \code{median} which replaces the missing values with the median of each rows (observations), \code{knn} is the method in package \code{bnstruct}, \code{als} and \code{svd} are methods from \code{softImpute} package, \code{CA}, \code{PCA} and \code{FAMD} are from \code{missMDA} package, others are from the \code{mice} package.
}
\examples{
# load part of the beatAML data
beatAML_data <- NIMAA::beatAML[1:10000,]

# convert to incidence matrix
beatAML_incidence_matrix <- el2IncMatrix(beatAML_data)

# predict the edges by imputation the wights
predictEdge(beatAML_incidence_matrix)
}
\seealso{
\code{\link[bnstruct]{knn.impute}},
\code{\link[softImpute]{softImpute}}, \code{\link[missMDA]{imputeCA}},
\code{\link[missMDA]{imputeFAMD}}, \code{\link[missMDA]{imputePCA}},
\code{\link[mice]{mice}}.
}
