#' PbHeron
#'
#' @description
#' From the `NADA` R-Package.
#'
#' Lead concentrations in the blood and several organs of herons in Virginia.
#'
#' Objective is to determine the relationships between lead concentrations in the blood and various organs. Do concentrations reflect environmental lead concentrations, as represented by dosing groups? There is one detection limit, at 0.02 ug/g. Used in Chapters 10 and 11 of the Helsel (2011).
#'
#' @usage data(PbHeron)
#'
#' @docType data
#' @keywords dataset
#' @name PbHeron
#' @source Golden et al., 2003, Environmental Toxicology and Chemistry 22, pp. 1517-1524.
#' @references
#' Helsel, D.R., 2011. Statistics for censored environmental data using Minitab and R, 2nd ed. John Wiley & Sons, USA, N.J.

"PbHeron"
