% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/MultivariateRandomForest.R
\name{MultivariateRandomForest}
\alias{MultivariateRandomForest}
\title{Build Random or Multivariate Random Forest and Predicttion for Testing Samples}
\usage{
MultivariateRandomForest(trainX, trainY, n_tree, mtree, min_leaf, testX,
  Command)
}
\arguments{
\item{trainX}{Input matrix of M x N, M is the number of training samples and N is the number of features}

\item{trainY}{Output response of M x T, M is the number of samples and T is number of ouput Features(Response)}

\item{n_tree}{number of trees in the forest}

\item{mtree}{number of features will be used for each split}

\item{min_leaf}{minimum number of samples in the leaf node}

\item{testX}{Testing samples of Q x N, Q is the number of testing samples and N is the number of features(same order and
size used as training)}

\item{Command}{1 for RF and 2 for MRF}
}
\value{
Predicted response of Testing samples. For RF, prediction of the specific feature and for MRF. prediction of all the output features.
}
\description{
Random or Multivariate Random Forest using Training samples is built and the model is used to do
the prediction of Testing Samples
}
\examples{
trainX=matrix(runif(50*100),50,100)
trainY=matrix(runif(50*5),50,5)
n_tree=5
mtree=10
min_leaf=5
testX=matrix(runif(10*100),10,100)
Command=2#2 for MRF method
#Prediction size is 10 x 5, where 10 is the number 
#of testing samples and 5 is the number of output features
Prediction=MultivariateRandomForest(trainX, trainY, n_tree, mtree, min_leaf, testX,Command)

}
\references{
Breiman, Leo. "Random forests." Machine learning 45.1 (2001): 5-32.
}

