% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/TPI.R
\name{TPI}
\alias{TPI}
\title{Calculates Topographic Position Index}
\usage{
TPI(
  r,
  w = c(3, 3),
  na.rm = FALSE,
  include_scale = FALSE,
  filename = NULL,
  overwrite = FALSE,
  wopt = list()
)
}
\arguments{
\item{r}{DTM as a SpatRaster or RasterLayer}

\item{w}{A vector of length 2 specifying the dimensions of the rectangular window to use where the first number is the number of rows and the second number is the number of columns. Window size must be an odd number. Default is 3x3.}

\item{na.rm}{A logical indicating whether or not to remove NA values before calculations}

\item{include_scale}{logical indicating whether to append window size to the layer names (default = FALSE)}

\item{filename}{character Output filename.}

\item{overwrite}{logical. If TRUE, filename is overwritten (default is FALSE).}

\item{wopt}{list with named options for writing files as in writeRaster}
}
\value{
a SpatRaster or RasterLayer
}
\description{
Calculates Topographic Position Index (TPI). This is the value of the focal pixel minus the mean of the surrounding pixels (i.e. local mean but excluding the value of the focal pixel).
}
\examples{
r<- rast(volcano, extent= ext(2667400, 2667400 + 
ncol(volcano)*10, 6478700, 6478700 + nrow(volcano)*10), 
crs = "EPSG:27200")
tpi<- TPI(r, w=c(5,5), na.rm = TRUE)
plot(tpi)
}
\references{
Weiss, A., 2001. Topographic Position and Landforms Analysis. Presented at the ESRI user conference, San Diego, CA.
}
