% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/BiasCorrection.R
\name{FeedMat_M}
\alias{FeedMat_M}
\title{Computes an average or median feedback matrix across several bootstrap iterations}
\usage{
FeedMat_M(
  K1Z_j,
  N_boot,
  RiskFactors,
  GVARinputs,
  JLLinputs,
  FactorLabels,
  Economies,
  ModelType,
  Use_Mean
)
}
\arguments{
\item{K1Z_j}{Feedback matrix at the j_th iteration}

\item{N_boot}{Number of bootstrap samples per iteration.}

\item{RiskFactors}{A numeric matrix (T x F) representing the time series of risk factors.}

\item{GVARinputs}{List. Inputs for GVAR model estimation.}

\item{JLLinputs}{List. Inputs for JLL model estimation.}

\item{FactorLabels}{A list of character vectors with labels for all variables in the model}

\item{Economies}{A character vector containing the names of the economies included in the system.}

\item{ModelType}{A character vector indicating the model type to be estimated.}

\item{Use_Mean}{Choose between the mean or the median across the bootstrap iterations.}
}
\description{
Computes an average or median feedback matrix across several bootstrap iterations
}
\keyword{internal}
