% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/FMN__Rotate.R
\name{FMN__Rotate}
\alias{FMN__Rotate}
\title{Performs state rotations}
\usage{
FMN__Rotate(y0, U1, U0)
}
\arguments{
\item{y0}{list  of model parameters as described below}

\item{U1}{matrix (N x N)}

\item{U0}{vector (N x 1). Optional. Default: vector of zeros.}
}
\value{
y1 - list of outputs after the transformation, the structure parallels that of y0
}
\description{
Performs state rotations
}
\details{
This function performs a rotation from a model with Z as states to one with S = U0 + U1*Z as states. \cr
Specifically, each model is characterized by the following inputs organized in a list of variables:\cr
(i) K0: intercepts (N x 1);\cr
(ii) K1: feedback matrix (N x N*p); \cr
(iii) SS: volatility matrices (N x N*(M+1))\cr
More specifically, the state Z follows the dynamics: \cr
Z_t = N(K0 + K1 [Z_\{t-1\}; Z_\{t-2\}; ...],  SSi[ , , 1] + sum_\{i=1\}^M SSi[ , ,i+1]%*%V_\{i,t\}) \cr
where SSi <- array(SS, c(N, N, M+1))
}
\references{
#' This function is modified version of the "FMN__Rotate" function by Le and Singleton (2018). \cr
"A Small Package of Matlab Routines for the Estimation of Some Term Structure Models."\cr
(Euro Area Business Cycle Network Training School - Term Structure Modelling).
Available at: https://cepr.org/40029
}
