% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/higgins.fisher.kruskal.test.R
\name{higgins.fisher.kruskal.test}
\alias{higgins.fisher.kruskal.test}
\title{Fisher's LSD method applied to the Kruskal-Wallis test}
\usage{
higgins.fisher.kruskal.test(resp, grp, alpha = 0.05)
}
\arguments{
\item{resp}{vector containing the values for the variable of interest.}

\item{grp}{vector specifying in which group is each observation.}

\item{alpha}{level of the test.}
}
\value{
A matrix with two columns. Each row indicates a combinaison of two groups that have significant different distributions.
}
\description{
This function applies a rank-based method for controlling experiment-wise error. Two hypothesis have to be respected: normality of the distribution and no ties in the data. The aim is to be able to detect, among k treatments, those who lead to significant differencies in the values for a variable of interest.
}
\details{
First, the Kruskal-Wallis test is used to test the equality of the distributions of each treatment. If the test is significant at the level \code{alpha}, the method can be applied.
}
\references{
J.J. Higgins, (2004), \emph{Introduction to Modern Nonparametric Statistics}, Brooks/Cole, Cengage Learning.
}
