% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fun_readHMD.R
\name{ReadHMD}
\alias{ReadHMD}
\title{Download Data from HMD}
\usage{
ReadHMD(what, countries = NULL, interval = "1x1", username, password,
  save = TRUE)
}
\arguments{
\item{what}{what type of data are you looking for? There are death counts,
exposures, death-rates, life tables for females, life table for males,
life table for total population, cohort death-rates and cohort exposures. 
The codes: \code{births}, \code{population}, \code{lexis}, \code{Dx}, 
\code{Ex}, \code{mx}, \code{LT_f}, \code{LT_m}, \code{LT_t}, \code{e0}, 
\code{mxc} and \code{Exc}.}

\item{countries}{HMD country codes.}

\item{interval}{HMD data format: (age interval x year interval).
Interval options: \code{1x1}, \code{1x5}, \code{1x10}, 
\code{5x1}, \code{5x5}, \code{5x10}.}

\item{username}{your HMD username. If you don't have one you can sign up
for free on Human Mortality Database website.}

\item{password}{your HMD password.}

\item{save}{do you want to save a copy of the dataset on your local machine?}
}
\value{
An \code{ReadHMD} object that contains:

\item{input}{ list with the input data (except the password)}

\item{data}{ data downloaded from HMD}

\item{download.date}{ time stamp}
}
\description{
Download data for different countries and regions in a single object 
from the \href{http://www.mortality.org}{Human Mortality Database}.
}
\examples{
\dontrun{
# Download demographic data for 3 countries in 1x1 format 
age_int  <- 1  # age interval: 1,5
year_int <- 1  # year interval: 1,5,10
interval <- paste0(age_int, "x", year_int)  # --> 1x1
# And the 3 countries: Sweden Denmark and USA. We have to use the HMD codes
cntr  <- c('SWE', 'DNK', 'USA')  

# Download death counts. We don't want to export data outside R.
HMD_Dx <- ReadHMD(what = "Dx",
                  countries = cntr,
                  interval = interval,
                  username = "user@email.com",
                  password = "password",
                  save = FALSE)
ls(HMD_Dx)
HMD_Dx

# Download life tables for female population and export data.
HMD_LT_f <- ReadHMD(what = "LT_f",
                    countries = cntr,
                    interval = interval,
                    username = "user@email.com",
                    password = "password",
                    save = TRUE)
HMD_LT_f
} 
}
