% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.codgroup.r
\name{plot.codgroup}
\alias{plot.codgroup}
\title{Plot diagnostic for a codgroup object}
\usage{
\method{plot}{codgroup}(x, which, ...)
}
\arguments{
\item{x}{codgroup object resulting from a call to the codgroup function}

\item{which}{which type of plot to be produced (see details)}

\item{...}{other parameters to be passed through to plotting functions}
}
\description{
Four plots (selectable by \code{which}) are currently available. They provide details on the clustering process that led to the suggested grouping.
}
\details{
Four plots are curently available.

\describe{
  \item{which = 1}{Dendrogram from the hierarchical clustering algorithm}

  \item{which = 2}{Plot a list of different criteria for each possible values of \code{k}.}

  \item{which = 3}{Plot the clusters on the plan between the first two dimensions of a Principal Component Analysis.}

  \item{which = 4}{Plot the first difference of the force of mortality pooled by cluster.}

  }
}
\examples{

data(USA2000m)

grouping <- codgroup(USA2000m, k = "HGSD", x.range = 10:34)

plot(grouping, which = 3)

}
\seealso{
\link{codgroup}
}
