% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.codhump.r
\name{plot.codhump}
\alias{plot.codhump}
\title{Plot diagnostic for a codhump object}
\usage{
\method{plot}{codhump}(x, which, ...)
}
\arguments{
\item{x}{codhump object resulting from a call to the codhump function}

\item{which}{type of plot to be produced (see details)}

\item{...}{other parameters to be passed through to plotting functions}
}
\description{
Five plots (selectable by \code{which}) are currently available. Some are designed to estimate the pertinence of the choice of the parameters (plots 1 and 2),
others can serve as diagnostic to judge the quality of the fit (plot 3 and 4), and plot 5 illustrates the fitted cause- and age-specific contributions to the hump.
}
\details{
\code{Plot 1} displays the age-specific death rates for all-cause mortality (black), as well as the remaining group of causes that were not selected among the ones susceptible to contribute to the hump (grey).
If the remaining causes still display a hump, this is a sign that the typology chosen for the fit (\code{typ} argument) omits some other causes that contribute to the hump.
The colored lines represent the cause-deleted forces of mortality, i.e. the resulting age-specific death rates after the deletion of a given cause of death. The closer these lines are to the all-cause mortality, the smaller are their respective death rates.
If some of these lines follow very closely the all-cause death rates, it is worth considering eliminating them from the list of causes that are assumed to contribute to the hump, as their contribution is likely to be non-significant.
Keeping them probably adds more complexity to the model than it brings information.

\code{Plot 2} displays the independent fits of SSE models on each cause-deleted forces of mortality. These serve in turn as starting values for the constrained simultaneous fit (step 4 of the codhump algorithm).
This plot can be used as an indicator of poor choices in certain parameters, especially \code{x.hump} and \code{lambda}. For instance, if the value of \code{x.hump} is too large, the hump component may interfer with the senesence component by "competing" with it in the middle ages.
Alternatively, if a given cause accounts for all of the hump, the respective cause-deleted hump component will be hard to fit with an SSE model, which can translate visualy by unreasonable components.

\code{Plot 3} displays two diagnostic plots concerning the evolution of the optimization process.
The left panel indicates the evolution of the speed of convergence, which corresponds to the highest relative change in the coefficients of the splines of each cause and component.
It is expected that, after a certain number of iterations, the speed of convergence decreases as the current solutions approaches the optimal solution. Ultimately, the algorithm is stopped if this value falls below 1e-3.
The right panel indicates the amount of negative values within the cause- and age-specific contributions to the hump.
These negative values appear when the constraints are not respected (i.e. that the sum of each cause-specific contributions do not sum up to the overall hump, or that the cause-deleted forces of mortality are poorly approximated by the two components of the SSE model).
They are expected to disapear as the current solution approaches the optimal solution, but in some cases the solution may diverge from this consrtaint and the algorithm is stopped if the share of negative values starts increasing.

\code{Plot 4} displays the constrained SSE models on each of the cause-deleted forces of mortality. It also suggests a comparison with the all-cause SSE model, and the resulting age-specific contributions to the hump.
On the plot, these contributions appear in the form of the areas between the all-cause and the cause-deleted humps, which, in a counterfactual reasoning, can be interpreted as the contributions of each cause to the hump.

\code{Plot 5} displays the age-specific contributions to the hump by cause of death. These contributions are rescaled in order for the overall hump (black line) to sum up to 1.
Consequently, the overall curve can be interpreted as a probability density function (pdf).
This plot has two main functions: to control that the cause-specific contributions to the hump sum up to the overall hump, and to visualize the shape of these contributions. For summary indicators of these contributions, use \link{summary.codhump}.
}
\examples{

data("USA2000m")
typ <- list()
typ$tac <- 93
typ$sui <- 100
typ$hom <- 101
typ$poi <- c(97,98)
typ$oac <- c(94:96,99,102)
fit <- codhump(data = USA2000m, typ = typ, start.correct = TRUE)
plot(fit, which = 5)

}
\seealso{
\link{codhump}, \link{summary.codhump}
}

