% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/MonotoneHR.R
\name{monotoneHR}
\alias{monotoneHR}
\title{Estimate a non-decreasing hazard ratio function, together with a 100(1-\eqn{\alpha})\% confidence interval}
\usage{
monotoneHR(time.grid, S.data, T.data, ci.lvl = 0.05)
}
\arguments{
\item{time.grid}{A vector on which the hazard ratio function to be evaluated}

\item{S.data}{A dataframe containing observed survival time and censoring, it corresponds to the hazard function on the numerator}

\item{T.data}{A dataframe containing observed survival time and censoring, it corresponds to the hazard function on the demoninator}

\item{ci.lvl}{A number that specify the confidence level \eqn{\alpha}. Default is 0.05.}
}
\value{
\code{hr} The estimated hazard ratio

\code{tau} The estimated scaled parameter of the limiting Chernoff distribution

\code{ci.upper} and \code{ci.lower} are the upper bound and lower bound of the estimated confidence interval
}
\description{
Estimate a non-decreasing hazard ratio function, together with a 100(1-\eqn{\alpha})\% confidence interval
}
\examples{
#'
}
