% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mult-mshapes.R
\name{mshapes}
\alias{mshapes}
\alias{mshapes.list}
\alias{mshapes.array}
\alias{mshapes.Ldk}
\alias{mshapes.OutCoe}
\alias{mshapes.OpnCoe}
\alias{mshapes.LdkCoe}
\alias{mshapes.PCA}
\alias{MSHAPES}
\title{Mean shape calculation for Coo, Coe, etc.}
\usage{
mshapes(x, ...)

\method{mshapes}{list}(x, FUN = mean, ...)

\method{mshapes}{array}(x, FUN = mean, ...)

\method{mshapes}{Ldk}(x, FUN = mean, ...)

\method{mshapes}{OutCoe}(x, fac, FUN = mean, nb.pts = 120, ...)

\method{mshapes}{OpnCoe}(x, fac, FUN = mean, nb.pts = 120, ...)

\method{mshapes}{LdkCoe}(x, fac, FUN = mean, ...)

\method{mshapes}{PCA}(x, fac, ...)

MSHAPES(x, ...)
}
\arguments{
\item{x}{a list, array, Ldk, LdkCoe, OutCoe or OpnCoe or PCA object}

\item{...}{useless here.}

\item{FUN}{a function to compute the mean shape (\link{mean} by default, by \link{median} can be considered)}

\item{fac}{factor from the $fac slot (only for Coe objects). See examples below.}

\item{nb.pts}{numeric the number of points for calculated shapes (only Coe objects)}
}
\value{
the averaged shape; on Coe objects, a list with two components: \code{$Coe} object of the same class, and
\code{$shp} a list of matrices of (x, y) coordinates.
}
\description{
Quite a versatile function that calculates mean (or median, or whatever function)
on list or an array of shapes, an Ldk object. It can also be used on OutCoe and OpnCoe objects.
In that case, the reverse transformation (from coefficients to shapes) is calculated, (within
groups defined with the fac argument if provided) and the Coe object is returned.
}
\details{
Note that on Coe objects, the average can be made within levels of the passed $fac (if any);
in that case, the other columns of the fac are also returned, using the first row within every level, but they may
not be representative of the group. Also notice that for PCA objects, mean scores are returned
within a PCA object (accessible with \code{PCA$x}) that can be plotted directly but other slots are left
unchanged.
}
\examples{
#### on shapes
mshapes(wings)
mshapes(wings$coo)
mshapes(coo_sample(bot, 24)$coo)
stack(wings)
coo_draw(mshapes(wings))

bot.f <- efourier(bot, 12)
mshapes(bot.f) # the mean (global) shape
ms <- mshapes(bot.f, 'type')
ms$Coe
class(ms$Coe)
ms <- ms$shp
coo_plot(ms$beer)
coo_draw(ms$whisky, border='forestgreen')
tps_arr(ms$whisky, ms$beer) #etc.

op <- npoly(filter(olea, view=='VL'), 5)
ms <- mshapes(op, 'var') #etc
ms$Coe
panel(Opn(ms$shp), names=TRUE)

wp <- fgProcrustes(wings, tol=1e-4)
ms <- mshapes(wp, 1)
ms$Coe
panel(Ldk(ms$shp), names=TRUE) #etc.
panel(ms$Coe) # equivalent (except the $fac slot)
}
\seealso{
Other multivariate: \code{\link{CLUST}},
  \code{\link{KMEANS}}, \code{\link{LDA}},
  \code{\link{MANOVA_PW}}, \code{\link{MANOVA}},
  \code{\link{PCA}}, \code{\link{classification_metrics}}
}
