% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/core-calibrate.R
\name{calibrate_reconstructions}
\alias{calibrate_reconstructions}
\alias{calibrate_reconstructions_efourier}
\alias{calibrate_reconstructions_rfourier}
\alias{calibrate_reconstructions_tfourier}
\alias{calibrate_reconstructions_sfourier}
\alias{calibrate_reconstructions_npoly}
\alias{calibrate_reconstructions_opoly}
\alias{calibrate_reconstructions_dfourier}
\title{Calibrate using reconstructed shapes}
\usage{
calibrate_reconstructions()

calibrate_reconstructions_efourier(x, id, range = 1:9)

calibrate_reconstructions_rfourier(x, id, range = 1:9)

calibrate_reconstructions_tfourier(x, id, range = 1:9)

calibrate_reconstructions_sfourier(x, id, range = 1:9)

calibrate_reconstructions_npoly(x, id, range = 2:10, baseline1 = c(-1, 0),
  baseline2 = c(1, 0))

calibrate_reconstructions_opoly(x, id, range = 2:10, baseline1 = c(-1, 0),
  baseline2 = c(1, 0))

calibrate_reconstructions_dfourier(x, id, range = 2:10, baseline1 = c(-1,
  0), baseline2 = c(1, 0))
}
\arguments{
\item{x}{the \code{Coo} object on which to calibrate_reconstructions}

\item{id}{the shape on which to perform calibrate_reconstructions}

\item{range}{vector of harmonics on which to perform calibrate_reconstructions}

\item{baseline1}{\eqn{(x; y)} coordinates for the first point of the baseline}

\item{baseline2}{\eqn{(x; y)} coordinates for the second point of the baseline}

\item{...}{only used for the generic}
}
\value{
a ggplot object and the full list of intermediate results. See examples.
}
\description{
Calculate and displays reconstructed shapes using a
range of harmonic number. Compare them visually with the maximal fit.
This explicitely demonstrates how robust efourier is compared to tfourier and rfourier.
}
\examples{

### On Out
shapes \%>\%
    calibrate_reconstructions_efourier(id=1, range=1:6)

# you may prefer efourier...
shapes \%>\%
    calibrate_reconstructions_tfourier(id=1, range=1:6)

#' you may prefer efourier...
shapes \%>\%
    calibrate_reconstructions_rfourier(id=1, range=1:6)

#' you may prefer efourier... # todo
#shapes \%>\%
#     calibrate_reconstructions_sfourier(id=5, range=1:6)

### On Opn
olea \%>\%
    calibrate_reconstructions_opoly(id=1)

olea \%>\%
    calibrate_reconstructions_npoly(id=1)

olea \%>\%
    calibrate_reconstructions_dfourier(id=1)

}
\seealso{
Other calibration: \code{\link{calibrate_deviations}},
  \code{\link{calibrate_harmonicpower}},
  \code{\link{calibrate_r2}}
}
