% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/DiscreteLearning.R
\name{goodnessDiscreteVariables}
\alias{getBICDiscreteBN}
\alias{getlogLikelihoodDiscreteBN}
\alias{goodnessDiscreteVariables}
\title{Goodness of discrete probabilities}
\usage{
getlogLikelihoodDiscreteBN(discreteBN)

getBICDiscreteBN(discreteBN, sameData = FALSE)
}
\arguments{
\item{discreteBN}{A list of multiples lists. Each list contains two entries,
the probabilities and the size of the data which is in each leaf of the discrete tree.}

\item{sameData}{A logical argument; if \code{FALSE} means differents datasets had been used for the learnings.}
}
\value{
The loglikelihood and the BIC of the discrete network.
}
\description{
Get the loglikelihood and the BIC for discrete models, i.e discrete Bayesian Networks.
}
\examples{
## 1. EXAMPLE
## Discrete data
X <- rep(c("yes", "no", "maybe"), 500)
Y <- rep(c("M", "F"), 750)
data <- data.frame(X=X, Y=Y)
disVar <- c("X","Y")
data <- discreteVariables_as.character(data, discreteVariables=disVar)
n <- nrow(data)

## Probabilities
s <- discreteVariablesStates(namevariables=disVar, discreteData=data)
p <- lapply(1:length(s), function(i) probDiscreteVariable(stateNames=
s[[i]]$states, Variable=data[,i]))

## Log-likelihood
getlogLikelihoodDiscreteBN(p)

## BIC
getBICDiscreteBN(p, sameData = TRUE)

## 2. EXAMPLE
## Discrete variables
X <- rep(c("1", "2", "3"), 500)
data <- data.frame(X=as.character(X))
s <- discreteVariablesStates(namevariables="X", discreteData=data)
p1 <- probDiscreteVariable(stateNames = s[[1]]$states, Variable = data[,1])

Y <- rep(c("YES", "NO"), 100)
data <- data.frame(Y = as.character(Y))
s <- discreteVariablesStates(namevariables = "Y", discreteData = data)
p2 <- probDiscreteVariable(stateNames = s[[1]]$states, Variable = data[,1])
## Probabilities
P <- list(p1,p2)

## Log-likelihood
getlogLikelihoodDiscreteBN(P)

## BIC
getBICDiscreteBN(P, sameData = TRUE)
}

