% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/paretomix.R
\name{paretomix1}
\alias{paretomix1}
\title{Maximum Smoothed Likelihood Estimation for a Class of Semiparametric Pareto Mixture Densities}
\usage{
paretomix1(y, n, numc, est_alpha, est_beta, est_p, est_h, h, maxiter = 100)
}
\arguments{
\item{y}{observations as vector.}

\item{n}{number of observations length(y)}

\item{numc}{number of components}

\item{est_alpha}{initial value for alpha, the scale parameter of pareto distribution}

\item{est_beta}{initial value for beta, the shape parameter of pareto distribution}

\item{est_p}{initial values for proportions, in vector}

\item{est_h}{density for nonparametric component.}

\item{h}{bandwidth h for kernel estimation}

\item{maxiter}{maximum iteration the algorithm run, default is 100}
}
\value{
est_beta: estimated beta
est_p: estimated proportion
est_h: estimated density for nonparametric component
est_mu: estimated component means
likelihood: likelihood of observations
}
\description{
Maximum Smoothed Likelihood Estimation for a Class of Semiparametric Pareto Mixture Densities
}
\examples{

data(ROE)
y=as.matrix(ROE[1:1000,]) #used a smaller sample for a quicker demonstration of the function
n=length(y);
h= 1.06*(n*(1-0.102))^(-1/5)* min(sd(y), quantile(y,0.25)/1.34);
est_alpha=0.065;
est_beta=2.911;
est_p=c(0.102,0.898);
est_mu=0.1172;
est_h = 3.33* dt(3.33*(y-est_mu),2);#est_h=dnorm(y-est_mu,0)
numc=2;
out =paretomix1(y,n,numc,est_alpha,est_beta,est_p,est_h,h,maxiter=1);
}
