% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/kmmMixedData.R
\docType{class}
\name{KmmMixedDataModel}
\alias{KmmMixedDataModel}
\alias{KmmMixedDataModel-class}
\title{Definition of the [\code{\linkS4class{KmmMixedDataModel}}] class}
\description{
This class defines a mixed data kernel mixture Model (KMM).
}
\details{
This class inherits from the [\code{\linkS4class{IClusterModel}}] class.
A model for mixed data is a mixture model of the form:
\deqn{
f({{x}}_i=({{x}}_{1i}, {{x}}_{2i},\ldots {{x}}_{Li})|\theta)
= \sum_{k=1}^K p_k \prod_{l=1}^L h({{x}}_{li}).
}
The density functions (or probability distribution functions)
\deqn{h(.)} can be any implemented kmm model on a RKHS space.
}
\section{Slots}{

\describe{
\item{\code{lcomponent}}{a list of [\code{\linkS4class{KmmComponent}}]}
}}

\examples{
getSlots("KmmMixedDataModel")

}
\seealso{
[\code{\linkS4class{IClusterModel}}] class
}
\author{
Serge Iovleff
}
