\name{LegNorm}
\alias{LegNorm}
\title{Evaluating Legendre's Polynomials of Degree 1, 2, 3, or 4
}
\description{
This function evaluates the values of Legendre polynomials of degrees 1 to 4
on [0,1] at a value(s) x.
}
\usage{
LegNorm(x)
}
\arguments{
 \item{x}{
A scaler or vector of values at which the Legendre's ploynomials are to be evaluated.
}
}
\value{
 The returned list has the following elements:

 \item{p1}{p1 is value(s) of the Legendre's polynomial of degree 1 at x}

 \item{p2}{p2 is value(s) of the Legendre's polynomial of degree 2 at x}

 \item{p3}{p3 is value(s) of the Legendre's polynomial of degree 3 at x}

 \item{p4}{p4 is value(s) of the Legendre's polynomial of degree 4 at x}
}
\references{
David, F. N. (1939). ``On Neyman's "smooth" test for goodness of fit: I. Distribution of the criterion Psi2 when the hypothesis tested is true,''
\emph{Biometrika,} 31, 191-199.
}
\author{
Mortaza Jamshidian, Siavash Jalal, and Camden Jansen
}
\note{
Legendre's polynomias on [0,1] are calculated.
}

\examples{
p <- LegNorm(c(5.2,11,15))
p$p3
}
