% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/controls.R
\name{search_exact_seq_pq}
\alias{search_exact_seq_pq}
\title{Search for exact matching of sequences}
\usage{
search_exact_seq_pq(physeq, seq2search)
}
\arguments{
\item{physeq}{(required): a \code{\link[phyloseq]{phyloseq-class}} object obtained
using the \code{phyloseq} package.}

\item{seq2search}{A DNAStringSet object of sequences to search for.}
}
\value{
A list of data-frames for each input sequences with the name,
the sequences and the
number of occurrences of the original sequence, the complement sequence,
the reverse sequence and the reverse-complement sequence.
}
\description{
\if{html}{\out{
<a href="https://adrientaudiere.github.io/MiscMetabar/articles/Rules.html#lifecycle">
<img src="https://img.shields.io/badge/lifecycle-experimental-orange" alt="lifecycle-experimental"></a>
}}


Search for exact matching of sequences using complement,
reverse and reverse-complement
}
\examples{
data("data_fungi")
search_primers <- search_exact_seq_pq(data_fungi,
  seq2search = Biostrings::DNAStringSet(c("TTGAACGCACATTGCGCC", "ATCCCTACCTGATCCGAG"))
)
}
\author{
Adrien Taudière
}
