% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/vsearch.R
\name{chimera_removal_vs}
\alias{chimera_removal_vs}
\title{Search for a list of sequence in an object to remove chimera taxa
using \href{https://github.com/torognes/vsearch}{vsearch}}
\usage{
chimera_removal_vs(object, type = "Discard_only_chim", clean_pq = FALSE, ...)
}
\arguments{
\item{object}{(required) A phyloseq-class object or one of dada, derep,
data.frame or list coercible to sequences table using the
function \code{\link[dada2:makeSequenceTable]{dada2::makeSequenceTable()}}}

\item{type}{(default "Discard_only_chim"). The type define the type of
filtering.
\itemize{
\item "Discard_only_chim" will only discard taxa classify as chimera by vsearch
\item "Select_only_non_chim" will only select taxa classify as non-chimera by
vsearch(after filtering taxa based on their sequence length by the
parameter \code{min_seq_length} from the \code{\link[=chimera_detection_vs]{chimera_detection_vs()}} function)
\item "Select_only_chim" will only select taxa classify as chimera by
vsearch (after filtering taxa based on their sequence length by the
parameter \code{min_seq_length} from the \code{\link[=chimera_detection_vs]{chimera_detection_vs()}} function)
}}

\item{clean_pq}{(logical; default FALSE) If TRUE, return the phyloseq object
after cleaning using the default parameter of \code{\link[=clean_pq]{clean_pq()}} function.}

\item{...}{Others arguments passed on to \code{\link[=chimera_detection_vs]{chimera_detection_vs()}} function}
}
\value{
\itemize{
\item I/ a sequences tables if object is of class dada, derep, data.frame or
list.
\item II/ a phyloseq object without (or with if type = 'Select_only_chim')
chimeric taxa
}
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#experimental}{\figure{lifecycle-experimental.svg}{options: alt='[Experimental]'}}}{\strong{[Experimental]}}
}
\details{
This function is mainly a wrapper of the work of others.
Please make \href{https://github.com/torognes/vsearch}{vsearch}.
}
\examples{
\dontshow{if (MiscMetabar::is_vsearch_installed()) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
\donttest{
data_fungi_nochim <- chimera_removal_vs(data_fungi)
data_fungi_nochim_16 <- chimera_removal_vs(data_fungi,
  abskew = 16,
  min_seq_length = 10
)
data_fungi_nochim2 <-
  chimera_removal_vs(data_fungi, type = "Select_only_non_chim")
data_fungi_chimera <-
  chimera_removal_vs(data_fungi, type = "Select_only_chim")
}
\dontshow{\}) # examplesIf}
}
\seealso{
\code{\link[=chimera_detection_vs]{chimera_detection_vs()}}
}
\author{
Adrien Taudière
}
