% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ms_outlook_attachment.R
\docType{class}
\name{ms_outlook_attachment}
\alias{ms_outlook_attachment}
\title{Outlook mail attachment}
\format{
An R6 object of class \code{ms_outlook_attachment}, inheriting from \code{ms_outlook_object}, which in turn inherits from \code{ms_object}.
}
\description{
Class representing an attachment in Outlook.
}
\section{Fields}{

\itemize{
\item \code{token}: The token used to authenticate with the Graph host.
\item \code{tenant}: The Azure Active Directory tenant for the email account.
\item \code{type}: always "attachment" for an attachment.
\item \code{properties}: The attachment properties (metadata).
}
}

\section{Methods}{

\itemize{
\item \code{new(...)}: Initialize a new object. Do not call this directly; see 'Initialization' below.
\item \code{delete(confirm=TRUE)}: Delete this attachment. By default, ask for confirmation first.
\item \code{update(...)}: Update the attachment's properties (metadata) in Microsoft Graph.
\item \code{do_operation(...)}: Carry out an arbitrary operation on the attachment.
\item \code{sync_fields()}: Synchronise the R object with the attachment metadata in Microsoft Graph. This method does \emph{not} transfer the attachment content for a file attachment.
\item \code{download(dest, overwrite)}: For a file attachment, downloads the content to a file. The default destination filename is the name of the attachment.
}
}

\section{Initialization}{

Creating new objects of this class should be done via the the \code{get_attachment()}, \code{list_attachments()} or \code{create_attachment()} methods \code{\link{ms_outlook_email}} class. Calling the \code{new()} method for this class only constructs the R object; it does not call the Microsoft Graph API to retrieve or create the actual attachment.

In general, you should not need to interact directly with this class, as the \code{ms_outlook_email} class exposes convenience methods for working with attachments. The only exception is to download an attachment in a reliable way (not involving the attachment name); see the example below.
}

\examples{
\dontrun{

outl <- get_personal_outlook()

em <- outl$get_inbox$get_email("email_id")

# download the first attachment in an email
atts <- em$list_attachments()
atts[[1]]$download()

}
}
\seealso{
\code{\link{ms_outlook}}, \code{\link{ms_outlook_email}}

\href{https://docs.microsoft.com/en-us/graph/overview}{Microsoft Graph overview},
\href{https://docs.microsoft.com/en-us/graph/api/resources/mail-api-overview?view=graph-rest-1.0}{Outlook API reference}
}
