% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{sample_stochastic_vector}
\alias{sample_stochastic_vector}
\title{Sample a stochastic vector}
\usage{
sample_stochastic_vector(x, prob)
}
\arguments{
\item{x}{a vector}

\item{prob}{a matrix, it must have number of rows equal to \code{x} and rows that sum
to one}
}
\value{
a vector of length equal to the number of columns of \code{prob}
}
\description{
Given a vector of counts in cells, \code{x} and a stochastic matrix \code{prob}, each
row of which describes a probability distribution of how that cell should be
distributed among bins, sample destination bins for each cell count, and return
a vector giving the number of counts in bins. It is conceptually similar to
"stochastically" distributing the vector as \code{x \%*\% prob}, which gives the
expectation.
}
